package maratonacps2019_1;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * @author Prof. Henrique Louro
 */
public class Cidade {
    
    public static void main(String[] args) {
                
        List<CidSort> cidsort = new ArrayList();
        
        String linha = "";
        
        BufferedReader entrada;
        
        try {
            
            entrada = new BufferedReader(new InputStreamReader(System.in));
            
            while ((linha = entrada.readLine()) != null) {
                
                if (linha.equals("0")) {
                    break;
                }
                
                String temp[] = linha.split(";");
                
                boolean achou = false;
                
                for (CidSort c : cidsort) {
                    if (c.nome.equals(temp[3]) && c.estado.equals(temp[4])) {
                        c.valor += (Double.parseDouble(temp[2]) * Double.parseDouble(temp[5]));
                        achou = true;
                        break;
                    }
                }
                
                if (!achou) {
                    CidSort cs = new CidSort();
                    cs.nome = temp[3];
                    cs.estado = temp[4];
                    cs.valor = (Double.parseDouble(temp[2]) * Double.parseDouble(temp[5]));
                    cidsort.add(cs);
                }
            }
        } catch (Exception e) {
            System.out.println("Ocorreu um erro durante a leitura!\n" + e);
        }
        
        Comparator<CidSort> cds = (a, b) ->  Double.compare(b.valor, a.valor);

        cidsort.sort(cds);
        
        int cont = 0;
        
        for(CidSort cs : cidsort){
            System.out.println(cs.nome+" "+cs.estado+" "+(int)(cs.valor));
            cont++;
            if(cont>2){
                break;
            }
        }
    }
}

class CidSort {

        String nome;
        String estado;
        double valor;
    }
